<link rel="stylesheet" href="<?php echo base_url(); ?>backend/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">
<script src="<?php echo base_url(); ?>backend/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    
    <!-- Content Header (Page header) -->

    <?php
    $currency_symbol = $this->customlib->getSchoolCurrencyFormat();
    ?>

    <section class="content-header">
        <h1>
            <i class="fa fa-flask"></i> <?php echo $this->lang->line('receipt_book'); ?>
        </h1>
    </section>
    <section class="content">

        <div class="row">
            <div class="col-md-12" id="printArea">
                <div class="col-sm-12 visible-print">
                    <img src="<?php echo base_url(); ?>backend/images/s_logo.png" style="height: 80px;">
                </div>
                <div class="box box-success">
                    <div class="box-header">
                        <div class="col-sm-10">
                            <h4>Book Receipt</h4>
                        </div>
                        <div class="col-sm-2 text-right">
                            <h4>Order ID# <?php echo $orders[0]['order_id'] ?></h4>
                        </div>


                        <div class="col-xs-4">
                            <div class="box box-default">
                                <div class="box-header">
                                    <label><?php echo $this->setting_model->getCurrentSchoolName() ?></label>
                                </div>
                                <div class="box-body">
                                   <span ><?php echo $this->setting_model->getSchoolDetail()->dise_code ?></span><br/>
                                   <span ><?php echo $this->setting_model->getSchoolDetail()->email ?></span><br/>
                                </div>
                            </div>
                        </div>


                        <div class="col-xs-4">
                            <div class="box box-default">
                                <div class="box-header">
                                    <label>Order Details</label>
                                </div>
                                <div class="box-body">
                                    <b>Order Status :</b> <span id="order_status"><?php echo $parent_details[0]->father_name; ?></span><br/>
                                    <b>Order Taken By: </b> <span><?php echo $orders[0]['order_placed_by'] ?></span><br/>
                                    <b>Date: </b> <span id="vat_price"><?php echo  $order[0]['created_at']; ?></span><br/>
                                </div>
                            </div>
                        </div>


                        <div class="col-xs-4">
                            <div class="box box-default">
                                <div class="box-header">
                                    <label>Customer Details</label>
                                </div>
                                <div class="box-body">
                                    <b>Customer Name : </b> <span><?php echo $parent_details[0]->father_name; ?></span><br/>
                                    <b>Customer Id : </b> <span><?php echo $parent_details[0]->guardian_id; ?></span><br/>
                                    <b>Phone No: </b> <span><?php echo $parent_details[0]->father_phone; ?></span><br/>
                                </div>
                            </div>
                        </div>



                        <div class=col-xs-12>
                            <div class="box box-default">
                                <div class="box-header">
                                    <label>Order Details</label>
                                </div>
                                <div class="box-body">
                                    <div class="box-body table-responsive">
                                        <div >
                                            <table class="table table-hover table-striped table-bordered">
                                                <thead>
                                                <tr>
                                                    <th><?php echo $this->lang->line('isbn') ?></th>
                                                    <th><?php echo $this->lang->line('store_book_name') ?></th>

                                                    <th><?php echo $this->lang->line('std_order_qty') ?> </th>
                                                    <th><?php echo $this->lang->line('order_sold_qty') ?> </th>
                                                    <th><?php echo $this->lang->line('order_sold_qty1') ?> </th>
                                                    <th style="display:none"><?php echo $this->lang->line('remaining_amount') ?> </th>
                                                    <th><?php  echo $currency_symbol ." ". $this->lang->line('std_total_price') ?> </th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php $totalRemainingAmount = 0; $totalAmount = 0; $ordStatus = "Pending"; $isPending = false; $iscompleted = false; $isPartially = false; ?>
                                                <?php foreach ($orders as $p) {  $remainingBooks = (int)($p['quantity']) - (int)($p['sold_quantity']);   ?>
                                                    <tr>
                                                        <input type="hidden" name="order_id" value="<?php echo $p['order_id'] ?>"/>
                                                        <td class="mailbox-name"><?php echo $p["isbn"]; ?></td>
                                                        <td class="mailbox-name"><?php echo $p['title'] ?></td>

                                                        <td class="mailbox-name"><?php echo $p['quantity'] ?></td>
                                                        <td class="mailbox-name"><?php echo $p['sold_quantity'] ?></td>
                                                        <td class="mailbox-name">
                                                            <?php if($p['status'] == '1'){ ?>
                                                                <?php $iscompleted = true; $ordStatus = "Completed"; ?>
                                                                <span class="text-success"> <?php echo ((int)$p['quantity'] - (int)$p['sold_quantity']) ?></span>
                                                            <?php }elseif($p['status'] == '2'){ ?>
                                                                <?php $ordStatus = "Partially Completed"; $isPartially = true; ?>
                                                                <span class="text-warning"><?php echo $remainingBooks; ?></span>
                                                            <?php }else{?>
                                                                <span class="text-danger"><?php echo ((int)$p['quantity'] - (int)$p['sold_quantity']) ?></span>
                                                            <?php  $isPending = true;   }?>

                                                        </td>
                                                        <td style="display:none" class="mailbox-name">

                                                            <?php echo ((int)($p['price']) * $remainingBooks); ?>

                                                        </td>
                                                        <td class="mailbox-name"><?php echo(number_format($p['f_price'], 2, '.', '')); ?>

                                                        </td>
                                                    </tr>
                                                    <?php
                                                    $totalRemainingAmount += ((int)($p['price']) * $remainingBooks);
                                                    $totalAmount += floatval($p['f_price']);
                                                }

                                                if($isPartially){
                                                    $ordStatus = "Partially Completed";
                                                }
                                                elseif($isPending && $iscompleted){
                                                    $ordStatus = "Partially Completed";
                                                }elseif($iscompleted){
                                                    $ordStatus = "Completed";
                                                }elseif ($isPending){
                                                    $ordStatus = "Pending";
                                                }else{
                                                    $ordStatus = "Pending";
                                                }




                                                ?>

                                                <tr>
                                                    <th colspan="7">
                                                        <hr/>
                                                    </th>
                                                </tr>
                                                <tr>
                                                    <th></th>

                                                    <th></th>
                                                    <th></th>
                                                    <th></th>
                                                    <th style="display:none"><?php echo $totalRemainingAmount; ?></th>
                                                    <th class="text-right">Sub Total</th>
                                                    <th> <?php echo $currency_symbol.' '.$totalAmount;  ?>

                                                    </th>
                                                </tr>
                                                <tr>
                                                    <th></th><th></th>

                                                    <th></th>
                                                    <th></th>
                                                    <th style="display:none"><?php echo $currency_symbol.$totalRemainingAmount; ?></th>
                                                    <th class="text-right">VAT
                                                      <?php $tax = (int)$sales_tax["sales_tax"];
                                                      echo "<small> (".$tax."%) </small>";
                                                      ?>
                                                    </th>
                                                    <th ><span id="total_price">
                                                            <?php
                                                            echo  $currency_symbol.' '.(number_format($tax * $totalAmount /100, 2, '.', ''));
                                                            ?>
                                                        </span>  </th>
                                                </tr>


                                                <tr>
                                                    <th></th><th></th>

                                                    <th></th>
                                                    <th></th>
                                                    <th style="display:none"><?php echo $totalRemainingAmount; ?></th>
                                                    <th class="text-right">Total Price</th>
                                                    <th ><span id="total_price">
                                                            <?php
                                                            $tax = (int)$sales_tax["sales_tax"];
                                                            echo $currency_symbol.' '.(number_format(($tax * $totalAmount /100) + $totalAmount, 2, '.', ''));
                                                            ?>

                                                        </span> </th>
                                                </tr>


                                                </tbody>

                                            </table>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="box-footer text-right">
                                <button type="button" class="btn btn-sm btn-success hidden-print"  onclick="printDiv( '<?php echo $ordStatus ?>' )">Print Receipt</button>

                            </div>
                            <br/>
                            <div class="visible-print">
                                <div class=col-xs-6>
                                    <span><b>Stamp</b><hr/></span>
                                </div>
                                <div class="col-xs-6">
                                    <span><b>Signature</b><hr/></span>
                                </div>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script type="text/javascript">

    orderStatus();
    function orderStatus(){
        document.getElementById("order_status").innerText = '<?php echo $ordStatus; ?>';
    }


    function printDiv(status) {

        document.getElementById("order_status").innerText = status;

        var printContents = document.getElementById('printArea').innerHTML;
        var originalContents = document.body.innerHTML;

        document.body.innerHTML = printContents;

        window.print();

        document.body.innerHTML = originalContents;
    }
</script>

